/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import org.figuramc.figura.utils.TextUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4i;

public class ClickableTextHelper {
    protected TextLine[] lines;
    protected HashMap<Vector4i, String> clickUrls = new HashMap();
    protected HashMap<Vector4i, Component> hoverText = new HashMap();
    protected boolean dirty = true;
    protected Component message;

    public void setMessage(@Nullable Component message) {
        if (this.message == message) {
            return;
        }
        this.message = message;
        if (message == null) {
            this.clear();
            return;
        }
        this.dirty = true;
    }

    public void renderDebug(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        for (Vector4i area : this.hoverText.keySet()) {
            graphics.renderOutline(x + area.x, y + area.y, area.z - area.x, area.w - area.y, ClickableTextHelper.isPointWithinBounds(area, x, y, mouseX, mouseY) ? -16711936 : -65281);
        }
        for (Vector4i area : this.clickUrls.keySet()) {
            graphics.renderOutline(x + area.x, y + area.y, area.z - area.x, area.w - area.y, ClickableTextHelper.isPointWithinBounds(area, x, y, mouseX, mouseY) ? -16711936 : -65281);
        }
        graphics.renderOutline(mouseX - 1, mouseY - 1, 3, 3, -16711681);
    }

    public void update(Font font, int lineWidth) {
        if (!this.dirty || this.message == null) {
            return;
        }
        this.dirty = false;
        this.clear();
        ArrayList<TextLine> lines = new ArrayList<TextLine>();
        List split = font.getSplitter().splitLines((FormattedText)this.message, lineWidth, Style.EMPTY);
        for (FormattedText curLine : split) {
            ArrayList nodes = new ArrayList();
            TextUtils.formattedTextToText(curLine).visit((style, string) -> {
                nodes.add(new TextNode(string, style));
                return Optional.empty();
            }, Style.EMPTY);
            lines.add(new TextLine(nodes.toArray(new TextNode[0])));
        }
        this.lines = lines.toArray(new TextLine[0]);
        this.visit((a, style, x, y, w, h) -> {
            Object value;
            ClickEvent clickEvent = style.getClickEvent();
            HoverEvent hoverEvent = style.getHoverEvent();
            if (clickEvent == null && hoverEvent == null) {
                return;
            }
            Vector4i rect = new Vector4i(x, y, x + w, y + h);
            if (clickEvent != null && clickEvent.getAction() == ClickEvent.Action.OPEN_URL) {
                this.clickUrls.put(rect, clickEvent.getValue());
            }
            if (hoverEvent != null && (value = hoverEvent.getValue(hoverEvent.getAction())) instanceof Component) {
                Component component = (Component)value;
                this.hoverText.put(rect, component);
            }
        });
    }

    @Nullable
    public Component getHoverTooltip(int cx, int cy, int mouseX, int mouseY) {
        for (Vector4i area : this.hoverText.keySet()) {
            if (!ClickableTextHelper.isPointWithinBounds(area, cx, cy, mouseX, mouseY)) continue;
            return this.hoverText.get(area);
        }
        return null;
    }

    @Nullable
    public String getClickLink(int cx, int cy, int mouseX, int mouseY) {
        for (Vector4i area : this.clickUrls.keySet()) {
            if (!ClickableTextHelper.isPointWithinBounds(area, cx, cy, mouseX, mouseY)) continue;
            return this.clickUrls.get(area);
        }
        return null;
    }

    public int lineCount() {
        return this.lines == null ? 1 : this.lines.length;
    }

    private static boolean isPointWithinBounds(Vector4i area, int xOffset, int yOffset, int x, int y) {
        int x1 = area.x + xOffset;
        int y1 = area.y + yOffset;
        int x2 = area.z + xOffset;
        int y2 = area.w + yOffset;
        return x > x1 && x < x2 && y > y1 && y < y2;
    }

    public void visit(MultilineTextVisitor visitor) {
        if (this.lines == null) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        int y = 0;
        for (TextLine line : this.lines) {
            int x = 0;
            for (TextNode node : line.nodes) {
                int width = node.getWidth(font);
                String string = node.text;
                Style style = node.style;
                Objects.requireNonNull(font);
                visitor.visit(string, style, x, y, width, 9);
                x += width;
            }
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public void clear() {
        this.lines = new TextLine[0];
        this.clickUrls.clear();
        this.hoverText.clear();
    }

    public void markDirty() {
        this.dirty = true;
    }

    protected record TextLine(TextNode[] nodes) {
    }

    protected record TextNode(String text, Style style) {
        public int getWidth(Font font) {
            return font.width((FormattedText)this.asText());
        }

        public Component asText() {
            return Component.literal((String)this.text).withStyle(this.style);
        }
    }

    @FunctionalInterface
    public static interface MultilineTextVisitor {
        public void visit(String var1, Style var2, int var3, int var4, int var5, int var6);
    }
}

